function B = replicate_struct2(A, val)

if ~exist('val', 'var'),
    val = 1;
end

B = A;

if isfloat(A),
    B = val * A;
elseif iscell(A),
    for i = 1:numel(A),
        B{i} = replicate_struct2(A{i}, val);
    end
elseif isstruct(A),
    fields = fieldnames(A);
    for f = 1:numel(fields),
        B.(fields{f}) = replicate_struct2(A.(fields{f}), val);
    end
end

end
