
function tuples = maketuples(factors)
    %tuples = [];
    tuples = zeros(400000, 4);
    idx = 1;
    total = 0;
    for i = 1:size(factors,1),
        fprintf(1, 'making tuples image %d of %d\n', i, size(factors,1));
        curfac = factors(i,:);

        idx1 = i;

        % find all indices in which one factor changes.
        idx1same = factors(:,1) == curfac(1);
        idx2same = factors(:,2) == curfac(2);
        idx3same = factors(:,3) == curfac(3);
        idx4same = factors(:,4) == curfac(4);

        sames = [ idx1same, idx2same, idx3same, idx4same ];
        onechanged = find(sum(sames,2) == 3);

        for j = 1:numel(onechanged),
            idx2 = onechanged(j);
            changedfac = find(sames(idx2,:)==0);
            notchanged = setdiff(1:4, changedfac);
            changedto = factors(idx2,changedfac);

            % For query, find all indices in which the changed factor
            % matches the reference.
            matches = find(factors(:,changedfac)==curfac(changedfac));

            for k = 1:numel(matches),
                idx3 = matches(k);
                queryfac = factors(idx3, :);
                idx1same = factors(:,changedfac) == changedto;
                idx2same = factors(:,notchanged(1)) == queryfac(notchanged(1));
                idx3same = factors(:,notchanged(2)) == queryfac(notchanged(2));
                idx4same = factors(:,notchanged(3)) == queryfac(notchanged(3));

                targets = find(idx1same & idx2same & idx3same & idx4same);

                % For target, find the unique matching target.
                for l = 1:numel(targets),
                    idx4 = targets(l);
                    %tuples = [ tuples; idx1, idx2, idx3, idx4 ];
                    tuples(idx, :) = [ idx1, idx2, idx3, idx4 ];
                    idx = idx + 1;
                    total = total + 1;
                end
            end
        end
    end
    tuples = tuples(1:total,:);
    fprintf('total: %d\n', total);
end

