function X = apply_softmax(X, pars)

idx = 1;
for i = 1:length(pars.card),
    istart = idx;
    iend = istart + pars.card(i) - 1;
    X(istart:iend,:) = bsxfun(@minus, X(istart:iend,:), max(X(istart:iend,:), [], 1));
    M = exp(X(istart:iend,:));
    D = sum(M,1);
    X(istart:iend,:) = bsxfun(@rdivide, M, D);
    idx = idx + pars.card(i);
end

end