function make_fewshot_splits()

splits = load('sprites_splits.mat');
labels = load('sprite_large_labels.txt');
trainlabels = labels(splits.trainidx,:);

rng('default');
rng(1);

numshots = [ 6, 12, 24, 48 ];
holdout_ids = cell(numel(numshots),1);
holdout_anims = [ 1:4; 5:8; 9:12; 13:16; 17:20 ];

numshot = numshots(end);
bow_idx = find(trainlabels(:,7)==0);
spear_idx = find(trainlabels(:,7)==1);
numbow = floor(numshot/2);
numspear = ceil(numshot/2);
prev_holdout_ids_bow = randsample(bow_idx, numbow);
prev_holdout_ids_spear = randsample(spear_idx, numspear);

for s = numel(numshots):-1:1,
    Rbow = randsample(1:numel(prev_holdout_ids_bow), floor(numshots(s)/2));
    Rspear = randsample(1:numel(prev_holdout_ids_spear), ceil(numshots(s)/2));
    holdout_ids{s} = [ prev_holdout_ids_bow(Rbow); ...
                       prev_holdout_ids_spear(Rspear) ];    
    prev_holdout_ids_bow = prev_holdout_ids_bow(Rbow);
    prev_holdout_ids_spear = prev_holdout_ids_spear(Rspear);
end

save('sprites_fewshot_splits.mat', 'holdout_ids', 'holdout_anims');

end

