function [X,Y] = standard_polygon( n, siz, transXY, rot, ...
    stretch_radian, stretch_ratio )
% [X,Y] = standard_polygon( n, siz, transXY, rot, ...
%    stretch_radian, stretch_ratio )
% siz: when >=0, the radius, when <0, 
%      the double distance from the center to the edge
% transXY: translation. When = 0 ([0 0]), the polygon centered at (0,0)
% rot: in radian
% stretch_radian, strech_ratio: stretch as a certain direction
% Remark: The first edge is parallel with x-axis. 
%         It is normal direction is taken as 0 angle


% init
assert( n>=3, 'at least has three vertices' );
if ~exist( 'siz', 'var' ) || isempty( siz )
    siz = 1;
end

if ~exist( 'transXY', 'var' ) || isempty( transXY )
    transXY = [0 0];
end
if isscalar(transXY)
    transXY = [transXY,transXY];
end

if ~exist( 'rot', 'var' ) || isempty( rot )
    rot = 0;
end

if ~exist( 'stretch_radian', 'var' ) || isempty( stretch_radian )
    stretch_radian = 0;
end

if ~exist( 'stretch_ratio', 'var' ) || isempty( stretch_ratio )
    stretch_ratio = 1;
end

is_circ = 0;
if isinf(n) % circle
    is_circ = 1;
    n=ceil(abs(siz)*pi)*2;
end

% generate vertices
A = (0:1/n:1)*(2*pi);
A = A(1:end-1);
% base rot (the first edge is parallel with x-axis, and taken as 0 angle)
A = A-(A(1)+A(2))/2+pi/2;

% base rotation

% stretch
A = A-stretch_radian;
X = cos(A); Y = sin(A);
Y = Y*stretch_ratio;
R = sqrt( X.*X+Y.*Y );
A = atan2(Y,X);
A = A+stretch_radian;

% custom rotation
A = A + rot;

% custom siz 
if siz>=0 || is_circ % siz is the radius
    R = R*(0.5*siz);
else    % (siz is the double distance from a vertex to the edge)
    R = R*(0.5*siz/(cos(1/n*pi)));
end

% custom transXY
X = R.*cos(A) + transXY(1); Y= R.*sin(A) + transXY(2);


