function [ batch_images, labels ] = ...
  sample_analogy_shapes_hard(data, id1, id2, tochange, pars)
    id1 = repmat(id1,pars.batchsize,1);
    id2 = repmat(id2,pars.batchsize,1);

    batch_images = struct;
    labels = struct;

    % Sample default angle, scale, xpos ypos (to be potentially
    % overwritten in the following).
    % One for the input pair, and one for the output pair.
    numscale = size(data,6);
    numangle = size(data,7);
    numxpos = size(data,8);
    numypos = size(data,9);
    angle_default1 = repmat(randsample(numangle,1),pars.batchsize,1);
    scale_default1 = repmat(randsample(numscale,1),pars.batchsize,1);
    xpos_default1 = repmat(randsample(numxpos,1),pars.batchsize,1);
    ypos_default1 = repmat(randsample(numypos,1),pars.batchsize,1);
    angle_default2 = repmat(randsample(numangle,1),pars.batchsize,1);
    scale_default2 = repmat(randsample(numscale,1),pars.batchsize,1);
    xpos_default2 = repmat(randsample(numxpos,1),pars.batchsize,1);
    ypos_default2 = repmat(randsample(numypos,1),pars.batchsize,1);

    % assign defaults to analogy particles 1,2,3,4.
    angle1 = angle_default1;
    angle2 = angle_default1;
    angle3 = angle_default2;
    angle4 = angle_default2;
    scale1 = scale_default1;
    scale2 = scale_default1;
    scale3 = scale_default2;
    scale4 = scale_default2;
    xpos1 = xpos_default1;
    xpos2 = xpos_default1;
    xpos3 = xpos_default2;
    xpos4 = xpos_default2;
    ypos1 = ypos_default1;
    ypos2 = ypos_default1;
    ypos3 = ypos_default2;
    ypos4 = ypos_default2;

    if tochange == 1, % angle
      % randomly pick rotation offset (20% chance of being 0).
      offset = randsample([-2,-1,1,2],1);
      angle1 = repmat(randsample(numangle,1),pars.batchsize,1);
      angle2 = angle1 + offset;
      angle2(angle2 < 1) = numangle + angle2(angle2 < 1);
      angle2(angle2 > numangle) = angle2(angle2 > numangle) - numangle;
      if offset > 0,
          angle3 = ones(pars.batchsize,1);
      else
          angle3 = repmat(numangle,pars.batchsize,1);
      end
      angle4 = angle3 + offset*(1:pars.batchsize)';
      angle4(angle4<1) = 1;
      angle4(angle4>numangle) = numangle;
    elseif tochange == 2, % scale
      offset = randsample([-1,1],1);
      scale1 = repmat(randsample(numscale,1),pars.batchsize,1);
      scale2 = scale1(:) + offset;
      % Handle boundary cases.
      if any((scale2<1) | (scale2>numscale)),
        offset = -1*offset;
      end
      scale2 = scale1 + offset;
      if offset > 0,
          scale3 = ones(pars.batchsize,1);
      else
          scale3 = repmat(numscale,pars.batchsize,1);
      end
      scale4 = scale3(:) + offset*(1:pars.batchsize)';
      scale4(scale4<1) = 1;
      scale4(scale4>numscale) = numscale;
    elseif tochange == 3, % xpos
      offset = randsample([-1,1],1);
      xpos1 = repmat(randsample(numxpos,1),pars.batchsize,1);
      xpos2 = xpos1(:) + offset;
      if any((xpos2<1) | (xpos2>numxpos)),
        offset = -1*offset;
      end
      xpos2 = xpos1 + offset;      
      if offset > 0,
          xpos3 = ones(pars.batchsize,1);
      else
          xpos3 = repmat(numxpos,pars.batchsize,1);
      end
      xpos4 = xpos3(:) + offset*(1:pars.batchsize)';
      xpos4(xpos4<1) = 1;
      xpos4(xpos4>numxpos) = numxpos;
    else % ypos
      offset = randsample([-1,1],1);
      ypos1 = repmat(randsample(numypos,1),pars.batchsize,1);
      ypos2 = ypos1(:) + offset;
      if any((ypos2<1) | (ypos2>numypos)),
        offset = -1*offset;
      end
      ypos2 = ypos1 + offset;
      if offset > 0,
          ypos3 = ones(pars.batchsize,1);
      else
          ypos3 = repmat(numypos,pars.batchsize,1);
      end
      ypos4 = ypos3(:) + offset*(1:pars.batchsize)';
      ypos4(ypos4<1) = 1;
      ypos4(ypos4>numypos) = numypos;
    end

    numcol = size(data,4);
    numshape = size(data,5);
    [ col1, shape1 ] = ind2sub([numcol, numshape], id1);
    [ col2, shape2 ] = ind2sub([numcol, numshape], id2);

    sz = size(data);
    sz = sz(4:end);
    try
    idx1 = sub2ind(sz, col1, shape1, scale1, angle1, xpos1, ypos1);
    idx2 = sub2ind(sz, col1, shape1, scale2, angle2, xpos2, ypos2);
    idx3 = sub2ind(sz, col2, shape2, scale3, angle3, xpos3, ypos3);
    idx4 = sub2ind(sz, col2, shape2, scale4, angle4, xpos4, ypos4);
    catch
        disp()
    end

    batch_images.X1 = data(:,:,:,idx1);
    batch_images.X2 = data(:,:,:,idx2);
    batch_images.X3 = data(:,:,:,idx3);
    batch_images.X4 = data(:,:,:,idx4);
    tmp = batch_images.X4(:,:,:,1:pars.batchsize-1);
    batch_images.X4(:,:,:,1) = batch_images.X3(:,:,:,1);
    batch_images.X4(:,:,:,2:end) = tmp;
    batch_images.target = batch_images.X4;
    
    labels.L1 = idx1;
    labels.L2 = idx2;
    labels.L3 = idx3;
    labels.L4 = idx4;
end
