function [M, labels] = polygon_mask_batch( ...
    colorDef, imSize, polyDef, polySizes, polyRots, transStride, transMargin )
% P = polygon_batch( imSize, polyDef, polySizes, polyRots, transStride, transMargin )
% M : (h,w,ch,color_id,shape_id,size_id,rot_id,trans_id,trans_id)
% example: M=polygon_mask_batch([1 0 0; 0 1 0; 0 0 1; 1 1 0],48,[4,0,1;4,0,0.5;3,0,1],24:4:36,(0:15:359)/180*pi,2,2);

[P, L0] = polygon_batch( imSize, polyDef, polySizes, polyRots, transStride, transMargin );

numColors = size(colorDef,1);

M = zeros([imSize,imSize, size(colorDef,2), numColors,size(P)],'like',colorDef);

if numel(P)>1e4 || ~isempty(gcp('nocreate'))
    parfor k = 1:numel(P)
        M(:,:,:,:,k) = polygon_mask_batch_k( colorDef, imSize, P{k} );
    end
else
    for k = 1:numel(P)
        M(:,:,:,:,k) = polygon_mask_batch_k( colorDef, imSize, P{k} );
    end
end

labels = [{colorDef},L0];



function M_k = polygon_mask_batch_k( colorDef, imSize, p )

numColors = size(colorDef,1);
msk = poly2mask( p(1,:), p(2,:), imSize, imSize );
M_k = zeros( [imSize,imSize, size(colorDef,2), numColors], 'like', colorDef );
for j=1:numColors
    for c=1:size(colorDef,2)
        B = zeros(imSize,imSize,'like',colorDef);
        B(msk) = colorDef(j,c);
        M_k(:,:,c,j) = B;
    end
end



function [P, labels] = polygon_batch( imSize, polyDef, polySizes, polyRots, transStride, transMargin )
% P = polygon_batch( imSize, polyDef, polySizes, polyRots, transStride, transMargin )
% P : {shape_id,size_id,rot_id,trans_id,trans_id}
% example: P=polygon_batch(48,[4,0,1;4,0,0.5;3,0,1],24:4:36,(0:15:359)/180*pi,2,2);

baseTrans = imSize/2;
if transStride>0  % use translation
    minPsiz = max(polySizes);
    halfTransNum = max(0,floor(((imSize - minPsiz)/2-transMargin)/transStride));
    ployTrans = baseTrans + (-halfTransNum:halfTransNum)*transStride;
else
    ployTrans = baseTrans;
end

labels = {1:size(polyDef,1), polySizes, polyRots, ployTrans, ployTrans};
labels = cellfun( @(a) {reshape(a,numel(a),1)}, labels );
[pdId, Sc,Rt,Tx,Ty] = ndgrid( labels{:} );
labels{1} = polyDef;

P = cell(size(Sc));

if numel(Sc)>1e5 || ~isempty(gcp('nocreate'))
    parfor k=1:numel(Sc)
        polyDef1 = polyDef;
        df = polyDef1(pdId(k),:);
        [X,Y] = standard_polygon( df(1), Sc(k), [Tx(k), Ty(k)], Rt(k), df(2), df(3) );
        P{k} = [X;Y];
    end
else
    for k=1:numel(Sc)
        df = polyDef(pdId(k),:);
        [X,Y] = standard_polygon( df(1), Sc(k), [Tx(k), Ty(k)], Rt(k), df(2), df(3) );
        P{k} = [X;Y];
    end
end

