function [M,L] = gen_shapes_data
% M = (h,w,ch,color_id,shape_id,size_id,rot_id,trans_id,trans_id)
% L is the label list for (color_id,shape_id,size_id,rot_id,trans_id,trans_id)

% color definition: m*3 matrix, each row specifies a color
colorDef = single([0.5 0.5 0.5; 0 0 1; 0 1 0; 0 1 1; 1 0 0; 1 0 1; 1 1 0; 1 1 1]); 
% size of an image
imSize   = 48;
% polygon definitions: m*3 matrix, each row specifies a polygon shape
%   each row: [num_of_vertices, strecth_radian, stretch_ratio]
polyDef  = [ ...
    4,0,1;      % square
    4,0,0.5;    % rectangule, h:w=1:2
%    4,pi/2,0.5; % diamond
    3,0,1;      % triangle
    inf,0,0.5];   % circle
% polygon size list
polySizes = 24:4:36;
% rotation list
polyRots = (0:15:359)/180*pi;
% translation stride, when = 0, no translation
transStride = 2;
% margin for translation, disabled when transStride==0
transMargin = 2;

% generate images
[M,L]=polygon_mask_batch(colorDef,imSize,polyDef,polySizes,polyRots, ...
    transStride,transMargin);


