function pred_nstep = ...
  analogy_repeated(expname, pars, hid_ref, hid_out, hid_query, nstep, need_backward)
    pred_nstep = zeros(pars.vdim,pars.vdim,3,nstep,'single');
    
    if ~exist( 'need_backward', 'var' ) || isempty(need_backward)
        need_backward = 0;
    end
    
    if ~iscell(hid_ref)
        hid_ref = {hid_ref};
        hid_out = {hid_out};
    end
    
    assert( numel(hid_ref)==numel(hid_out), ...
        'iterleaving cycle for hid_ref and hid_out should be the same' );
    inter_cycle = numel(hid_ref);
    
    switch(expname)
        case 'add'
            top = hid_query; trans = 0;
            for n = 1:nstep,
                if need_backward && n>ceil((nstep-1)/2)+1, trans=-trans; end
                top = trans + top;
                
                res = caffe('forward', { top }, 1);
                pred = res{1};
                pred_nstep(:,:,:,n) = pred(:,:,:,1);
                
                tId = mod(n-1,inter_cycle)+1;
                trans = hid_out{tId} - hid_ref{tId};
            end
        case 'mul'
            top = hid_query;
            % trans = hid_out - hid_ref;
            res1 = caffe('forward', { 0*hid_query; top }, 1);
            pred1 = res1{2};
            pred_nstep(:,:,:,1) = pred1(:,:,:,1);
            for n = 2:nstep,
                tId = mod(n-2,inter_cycle)+1;
                trans = hid_out{tId} - hid_ref{tId};
                if need_backward && n>ceil((nstep-1)/2)+1, trans=-trans; end
                res = caffe('forward', { trans; top }, 1);
                top = res{1};
                pred = res{2};
                pred_nstep(:,:,:,n) = pred(:,:,:,n);
            end
        case 'deep'
            top = hid_query;
            % trans = hid_out - hid_ref;
            res1 = caffe('forward', { 0*hid_query; top }, 1);
            pred1 = res1{2};
            pred_nstep(:,:,:,1) = pred1(:,:,:,1);
            for n = 2:nstep,
                tId = mod(n-2,inter_cycle)+1;
                trans = hid_out{tId} - hid_ref{tId};
                if need_backward && n>ceil((nstep-1)/2)+1, trans=-trans; end
                res = caffe('forward', { trans; top }, 1);
                top = res{1};
                pred = res{2};
                pred_nstep(:,:,:,n) = pred(:,:,:,n);
            end
    end
end
