function  [ cost, deltas] = grad_recon2(recon, target, pars)

err1 = recon{1} - target{1};
err2 = recon{2} - target{2};
err3 = recon{3} - target{3};
err4 = recon{4} - target{4};

cost = pars.lambda_mask*0.5*(err1(:)'*err1(:) + err3(:)'*err3(:)) + ...
       pars.lambda_rgb*0.5*(err2(:)'*err2(:) + err4(:)'*err4(:));

deltas = cell(4,1);
deltas{1} = pars.lambda_mask * err1;
deltas{2} = pars.lambda_rgb * err2;
deltas{3} = pars.lambda_mask * err3;
deltas{4} = pars.lambda_rgb * err4;

end


