function [ cost, delta_x, delta_m ] = grad_recon(X, M, Xt, Mt, pars)

if isfield(pars,'masked') && pars.masked
  err_x = bsxfun(@times, (X - Xt), Mt);
else
  err_x = X - Xt;
end
err_m = M - Mt;

cost_x = pars.lambda_rgb * 0.5*err_x(:)'*err_x(:) / pars.batchsize;
cost_m = pars.lambda_mask * 0.5*err_m(:)'*err_m(:) / pars.batchsize;

if isfield(pars,'masked') && pars.masked
  delta_x = pars.lambda_rgb * bsxfun(@times, err_x, Mt) / pars.batchsize;
else
  delta_x = pars.lambda_rgb * err_x / pars.batchsize;
end
delta_m = pars.lambda_mask * err_m / pars.batchsize;

cost = cost_x + cost_m;

end
