function [ cost, deltas ] = grad_hid2(ref, out, query, target, pred, S, pars)

deltas = cell(4,1);

tmp = out - ref;
err_sp = (1-S).*abs(tmp);
cost_sp = pars.beta * sum(sum(err_sp)) / pars.batchsize;
delta_sp = pars.beta * (1-S) .* sign(tmp) / pars.batchsize;

err_man = pred - target;
cost_man = 0.5*pars.alpha*err_man(:)'*err_man(:) / pars.batchsize;
delta_man = pars.alpha * err_man / pars.batchsize;

cost = cost_sp + cost_man;

deltas{1} = -delta_sp - delta_man; % ref
deltas{2} = delta_sp + delta_man;  % out
deltas{3} = delta_man;             % query
deltas{4} = -delta_man;            % target

end

