function [ cost_hid, delta_hid ] = grad_hid(ref, out, S, pars)

tmp = out - ref;
err_int = (1-S).*abs(tmp);
cost_hid = pars.beta * sum(sum(err_int)) / pars.batchsize;
delta_hid = pars.beta * (1-S) .* sign(tmp) / pars.batchsize;

end

