function matcaffe_init_cars_train(use_gpu, ...
                                  solver_enc, solver_dec, init_from)

if caffe('is_initialized') == 0
  caffe('init', solver_enc, solver_dec);
end

if exist('init_from', 'var'),
  model = load(init_from);
  caffe('set_weights', model.enc, 0);
  caffe('set_weights', model.dec, 1);
end

% set to use GPU or CPU
if use_gpu ~= -1
  fprintf('Using GPU Mode\n');
  caffe('set_mode_gpu');
  caffe('set_device', use_gpu);
else
  fprintf('Using CPU Mode\n');
  caffe('set_mode_cpu');
end
fprintf('Done with set_mode\n');

caffe('presolve', 0);
caffe('presolve', 1);

end
