% Column 1 is a random sample.
% Column 2 is a same-id sample
% Column 3 is a a different-id sample
% Column 4 is a same-pose sample
% Column 5 is a different-pose sampe.
function pairs = makepairs_for_verification(ids)
    numdata = length(ids);
    uids = unique(ids);
    pairs = zeros(numdata,3);
    idx = 1;
        
    for i = 1:length(uids),
        if uids(i) == -1,
            continue;
        end
        id = uids(i);
        matches = find(ids==id);
        nonmatches = find(ids~=id);
        num_matches = length(matches);

        if num_matches <= 1,
%             fprintf('ID %d no matches\n', id);
            continue;
        end
        
        mpairs = combnk(matches, 2);
        numcombos = size(mpairs,1);
        if numcombos > length(nonmatches),
            numcombos = length(nonmatches);
            mpairs = mpairs(1:numcombos,:);
        end
        % Sample and same-ID sample.
        pairs(idx:(idx+numcombos-1),1:2) = mpairs;
        % Different ID sample.
        pairs(idx:(idx+numcombos-1),3) = randsample(nonmatches,numcombos);
        idx = idx + numcombos;
    end
end
