% Column 1 is a random sample.
% Column 2 is a same-a different-b sample
% Column 3 is a a different-a same-b sample
function pairs = makepairs_2way(labs_a,labs_b)
    assert(length(labs_a)==length(labs_b));
    unique_a = unique(labs_a);
    pairs = [];
    for i = 1:length(unique_a),
        a = unique_a(i);
        matches = find(labs_a==a);
        num_matches = length(matches);
        if num_matches <= 1,
            continue;
        end
        % Form colums 1 and 2.
        col12 = combnk(matches,2);
        num_matches = size(col12,1);
        
        % Form column 3: different-a same-b.
        col3 = 0*col12(:,1);
        for j = 1:num_matches,
            b = labs_b(col12(j,1));
            nonmatches = find((labs_a~=a)&(labs_b==b));
            if isempty(nonmatches),
                col3(j) = 0;
            else
                col3(j) = randsample(nonmatches,1);
            end
        end
        
        newpairs = [ col12, col3 ];
        newpairs(col3==0,:) = [];
        pairs = [ pairs; newpairs ];
    end
    %{
    pairs = zeros(numdata,5);
    idx = 1;
    
    % Get examples of people from each pose.
    psample = cell(length(upose),1);
    for p = 1:length(upose),
        psample{p} = find((poses>=(p-0))&(poses<=(p+0)));
    end

    for i = 1:length(uids),
        id = uids(i);
        matches = find(ids==id);
        %nonmatches = find(ids~=id);
        num_matches = length(matches);

        if num_matches <= 1,
            fprintf('ID %d no matches\n', id);
            continue;
        end
        mpairs = combnk(matches, 2);
        numcombos = size(mpairs,1);
        % Sample and same-ID sample.
        pairs(idx:(idx+numcombos-1),1:2) = mpairs;
        for j = 1:numcombos,
            pose_j = poses(mpairs(j,1));
            % Different ID same pose.
            id_j = ids(mpairs(j,1));
            nonmatches = find((ids~=id_j)&(poses==pose_j));
            pairs(idx+j-1,3) = randsample(nonmatches,1);
            
            % Different ID different pose.
            notpose = randsample(setdiff(upose,pose_j),1);
            pairs(idx+j-1,4) = randsample(psample{pose_j},1);
            % Different ID same pose.
            pairs(idx+j-1,5) = randsample(psample{notpose},1);
        end
        idx = idx + numcombos;
    end
    %}
end
