function params = add_defaults(params)

% regularizer type
if ~isfield(params, 'type_a'),      params.type_a = 'no';               end
if ~isfield(params, 'type_b'),      params.type_b = 'no';               end

% global parameters
if ~isfield(params, 'savedir'),     params.savedir = 'results';         end
if ~isfield(params, 'dataset'),     params.dataset = 'dummy';           end
if ~isfield(params, 'optgpu'),      params.optgpu = 0;                  end
if ~isfield(params, 'maxiter'),     params.maxiter = 100;               end
if ~isfield(params, 'batchsize'),   params.batchsize = 100;             end

% momentum (stochastic gradient descent)
if ~isfield(params, 'momentum_init'),   params.momentum_init = 0.33;    end
if ~isfield(params, 'momentum_final'),  params.momentum_final = 0.5;    end
if ~isfield(params, 'momentum_change'), params.momentum_change = 5;     end

% learning rate and initialization
if ~isfield(params, 'eps'),         params.eps = 0.05;                  end
if ~isfield(params, 'eps_decay'),   params.eps_decay = 0.0;             end
if ~isfield(params, 'stdinit'),     params.stdinit = 0.01;              end
if ~isfield(params, 'upfactor'),    params.upfactor = 1;                end

% CD training
if ~isfield(params, 'usepcd'),      params.usepcd = 0;                  end
if ~isfield(params, 'kcd'),         params.kcd = 1;                     end
if ~isfield(params, 'negchain'),    params.negchain = params.batchsize; end
if ~isfield(params, 'nmf'),         params.nmf = 10;                    end

% regularizers (l2, l1, sparsity)
if ~isfield(params, 'l2reg'),       params.l2reg = 0.0;                 end
if ~isfield(params, 'l1reg'),       params.l1reg = 0.0;                 end
if ~isfield(params, 'sp_type'),     params.sp_type = 'approx';          end
if ~isfield(params, 'sp_damp'),     params.sp_damp = 0.9;               end
if ~isfield(params, 'pbias_a'),      params.pbias_a = 0;                end
if ~isfield(params, 'plambda_a'),   params.plambda_a = 0;               end
if ~isfield(params, 'pbias_b'),      params.pbias_b = 0;                end
if ~isfield(params, 'plambda_b'),   params.plambda_b = 0;               end

% visualizations
if ~isfield(params, 'verbose'),     params.verbose = 1;                 end

% some sanity check
if ~params.usepcd,
    params.negchain = params.batchsize;
end
if params.pbias_a == 0,
    params.plambda_a = 0;
end
if params.pbias_b == 0,
    params.plambda_b = 0;
end
if ~exist(['./' params.savedir], 'dir'),
    mkdir(['./' params.savedir]);
end

return
