startup;
load TFD_48x48.mat;

data = images;
data_flipped = flipdim(data, 3);
numex = 7;        % number of expressions plus one for unlabeled.
[ num_images, dim1, dim2 ] = size(data);
data = double(reshape(permute(data, [2 3 1]), [ dim1*dim2, num_images ]));
labs = labs_ex;

unlab_idx = (labs==-1);
trainX = data(:,unlab_idx)';

%%%%% Configuration
rfSize = 9;
%numBases=100;
numBases=50;
TFD_DIM=[48 48];
alpha = 0.25;  %% CV-chosen value for soft-threshold function.
lambda = 1.0;  %% CV-chosen sparse coding penalty.

%%%%% Dictionary Training %%%%%%
alg = 'omp1';   %% Use 1-hot VQ (OMP-1).  Test accuracy 79.96%

%%%%% Encoding %%%%%%
encoder='thresh'; encParam=alpha; %% Use soft threshold encoder.

%%%%% SVM Parameter %%%%%
switch (encoder)
 case 'thresh'
  L = 0.01; % L=0.01 for 1600 features.  Use L=0.03 for 4000-6000 features.
 case 'sc'
  L = 1.0; % May need adjustment for various combinations of training / encoding parameters.
end

%% Learn Dictionary on unlabeled data.
% extract random patches
numPatches = 400000;

patches = zeros(numPatches, rfSize*rfSize);

for i=1:numPatches
  if (mod(i,10000) == 0) fprintf('Extracting patch: %d / %d\n', i, numPatches); end
  r = random('unid', TFD_DIM(1) - rfSize + 1);
  c = random('unid', TFD_DIM(2) - rfSize + 1);
  patch = reshape(trainX(random('unid', size(trainX,1)),:), TFD_DIM);
  patch = patch(r:r+rfSize-1,c:c+rfSize-1);
  patches(i,:) = patch(:)';
end

% normalize for contrast
patches = bsxfun(@rdivide, bsxfun(@minus, patches, mean(patches,2)), sqrt(var(patches,[],2)+10));

% ZCA whitening (with low-pass)
C = cov(patches);
M = mean(patches);
[V,D] = eig(C);
P = V * diag(sqrt(1./(diag(D) + 0.1))) * V';
patches = bsxfun(@minus, patches, M) * P;

% run training
dictionary = run_omp1(patches, numBases, 50);

fname = sprintf('omp_tfd48_nb%d_l1.mat', numBases);
save(fname, 'dictionary', 'rfSize', 'M', 'P', 'encoder', 'encParam', 'L');

