% ==========================================
% script for tfd with manifold objective for
% both ID and expression.
% 
% "_a" refers to expression here.
% "_b" refers to identity here.
% ==========================================

startup;

% -- configuration
params = struct(...
    'optgpu', 5, ...
    'typein', 'real', ...
    'type_a', 'man', ...
    'numhid_a', 1000, ...
    'pbias_a', 0.2, ...
    'plambda_a', 0.3, ...
    'type_b', 'man', ...
    'numhid_b', 1000, ...
    'pbias_b', 0.2, ...
    'plambda_b', 0.1, ...
    'numfac', 700, ...
    'epsilon_add', 0.0005, ...
    'epsilon_mult', 0.0005, ...
    'nsample', 2000, ...
    'kmf', 15, ...
    'l2reg', 0, ...
    'maxiter', 300, ...
    'batchsize', 100, ...
    'kcd', 1, ...
    'mantype', 'drlim', ...
    'kman_a', 1, ...
    'thresh_a', 14, ...
    'kman_b', 6, ...
    'thresh_b', 4);

% -- train and evaluate
run_disbm_tfd(params,1:5);

