% ==========================================
% script for tfd with label for emotion and
% clamp for identity
%
% "_a" refers to expression here.
% "_b" refers to identity here.
% ==========================================

startup;

% -- configuration
params = struct(...
    'optgpu', 1, ...
    'typein', 'real', ...
    'type_a', 'label', ...
    'numhid_a', 1000, ...
    'pbias_a', 0.1, ...
    'plambda_a', 1, ...
    'type_b', 'clamp', ...
    'numhid_b', 1000, ...
    'pbias_b', 0.1, ...
    'plambda_b', 1, ...
    'numfac', 700, ...
    'eps', 0.001, ...
    'eta', 10, ...
    'nmf', 10, ...
    'l2reg_f', 0.0001, ...
    'l2reg', 0.001, ...
    'maxiter', 200, ...
    'batchsize', 200, ...
    'usepcd', 1, ...
    'kcd', 10, ...
    'negchain', 500, ...
    'eps_decay', 0.01, ...
    'momentum_change', 5, ...
    'momentum_init', 0.33, ...
    'momentum_final', 0.47, ...
    'saveiter', 50);

% -- train and evaluate
foldlist = 1:5;
run_disbm_tfd(params, foldlist);

