function XC = extract_omp(X, D, rfSize, DIM, M,P, encoder, encParam)
    numBases = size(D,1);
    
    % compute features for all training images
    XC = zeros(size(X,1), numBases*2*4);
    for i=1:size(X,1)
        if (mod(i,1000) == 0) fprintf('Extracting features: %d / %d\n', i, size(X,1)); end
        
        % extract overlapping sub-patches into rows of 'patches'
        patches = [ im2col(reshape(X(i,:),DIM), [rfSize, rfSize]) ]';

        % do preprocessing for each patch
        
        % normalize for contrast
        patches = bsxfun(@rdivide, bsxfun(@minus, patches, mean(patches,2)), sqrt(var(patches,[],2)+10));
        % whiten
        patches = bsxfun(@minus, patches, M) * P;
    
        % compute activation
        switch (encoder)
         case 'thresh'
          alpha=encParam;
          z = patches * D';
          patches = [ max(z - alpha, 0), -max(-z - alpha, 0) ];
          clear z;
         case 'sc'
          lambda=encParam;
          z = sparse_codes(patches, D, lambda);
          patches = [ max(z, 0), -min(z, 0) ];
         otherwise
          error('Unknown encoder type.');
        end
        % patches is now the data matrix of activations for each patch
        
        % reshape to 2*numBases-channel image
        prows = DIM(1)-rfSize+1;
        pcols = DIM(2)-rfSize+1;
        patches = reshape(patches, prows, pcols, numBases*2);
        
        % pool over 16ths.
        pooldim = [ 4 4 ];
        [ gridX, gridY ] = make_grid(prows, pcols, pooldim);
        numpool = prod(pooldim);
        for p = 1:numpool,
            pstart = 1+(p-1)*(2*numBases);
            pend = pstart+(2*numBases-1);
            XC(i,pstart:pend) = sum(sum(patches(gridX(p,:),gridY(p,:),:), 1), 2);
        end
    end
end

function [ gridX, gridY ] = make_grid(prows, pcols, pooldim)
    gridX = false(prod(pooldim), pcols);
    gridY = false(prod(pooldim), prows);
    for i = 1:pooldim(1),
        ystart = 1+(i-1)*(prows/pooldim(1));
        yend = ystart+(prows/pooldim(1))-1;
        for j = 1:pooldim(2),
            xstart = 1+(j-1)*(pcols/pooldim(2));
            xend = xstart+(pcols/pooldim(2))-1;
            
            idx = (i-1)*pooldim(1) + j;
            gridX(idx, xstart:xend) = true;
            gridY(idx, ystart:yend) = true;
        end
    end
end
