function [ha, hb] = disbm_infer_man(data, weights, params)

% make all in double precision
weights = gpu2cpu_struct(weights);

numdata = size(data, 2);
batchsize = 100;

numhid_a = params.numhid_a;
numhid_b = params.numhid_b;

ha = zeros(numhid_a, numdata);
hb = zeros(numhid_b, numdata);

for i = 1:ceil(numdata/batchsize),
    data_batch = data(:, (i-1)*batchsize+1:min(i*batchsize, numdata));
    [ha_batch, hb_batch] = disbm_infer_man_sub(data_batch, weights, params);

    ha(:, (i-1)*batchsize+1:min(i*batchsize, numdata)) = ha_batch;
    hb(:, (i-1)*batchsize+1:min(i*batchsize, numdata)) = hb_batch;
end

return;

% Inference for a subset of all data.
function [ha, hb] = disbm_infer_man_sub(data, weights, params)

batchsize = size(data, 2);
data = double(data);

% inference
wvha_v = weights.vishid_a*data;
wvhb_v = weights.vishid_b*data;
wvf = weights.visfac*data;

hbiasmat_a = repmat(weights.hidbias_a, [1 batchsize]);
hbiasmat_b = repmat(weights.hidbias_b, [1 batchsize]);

% initialize with visible-hidden connection
hb = sigmoid(wvhb_v + hbiasmat_b);
whbf = weights.hidfac_b*hb;
hb_old = hb;

ha = sigmoid(wvha_v + hbiasmat_a);
whaf = weights.hidfac_a*ha;
ha_old = ha;

% mean-field update (update a -> b)
for i = 1:params.kmf,
    ha = sigmoid(weights.hidfac_a'*(wvf.*whbf) + wvha_v + hbiasmat_a);
    whaf = weights.hidfac_a*ha;
    
    hb = sigmoid(weights.hidfac_b'*(wvf.*whaf) + wvhb_v + hbiasmat_b);
    whbf = weights.hidfac_b*hb;
end

return;
